import java.util.concurrent.*;

class PublisherDemo {
	public static void main(String[] args) throws InterruptedException {
		ExecutorService es = Executors.newCachedThreadPool();
		SubmissionPublisher<Integer> publisher = new SubmissionPublisher<>(es, 2);
		publisher.subscribe(new DemoSubscriber());
		publisher.subscribe(new DemoSubscriber());

		System.out.println("Die Produktion beginnt.");
		for (int i = 1; i <= 5; i++)
			publisher.offer(i, 2, TimeUnit.SECONDS, (sub, t) -> {
				sub.onError(new RuntimeException("Element " + t + " verloren"));
				System.err.println("Element " + t + " für " + sub + " verloren.");
				return false;
			});

		publisher.close();
		System.out.println("Der Publisher ist geschlossen");

		es.shutdown();
	}
}